<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chart in CodeIgniter</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <canvas id="myChart" width="400" height="200"></canvas>

    <script>
        // Fetch chart data from the backend
        fetch('<?= base_url('ChartController/get_chart_data') ?>')
            .then(response => response.json())
            .then(data => {
                const ctx = document.getElementById('myChart').getContext('2d');
                const myChart = new Chart(ctx, {
                    type: 'bar', // Type of chart
                    data: {
                        labels: data.labels, // Labels for x-axis
                        datasets: [
                            {
                                label: 'Users',
                                type: 'line', // Line chart for Users
                                data: data.users,
                                borderColor: 'rgba(54, 162, 235, 1)',
                                backgroundColor: 'rgba(54, 162, 235, 0.2)',
                                yAxisID: 'y1'
                            },
                            {
                                label: 'Orders',
                                type: 'bar', // Bar chart for Orders
                                data: data.orders,
                                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                                borderColor: 'rgba(255, 99, 132, 1)',
                                yAxisID: 'y2'
                            }
                        ]
                    },
                    options: {
                        scales: {
                            y1: {
                                type: 'linear',
                                position: 'left',
                                ticks: {
                                    beginAtZero: true
                                }
                            },
                            y2: {
                                type: 'linear',
                                position: 'right',
                                ticks: {
                                    beginAtZero: true
                                }
                            }
                        }
                    }
                });
            })
            .catch(error => console.error('Error fetching data:', error));
    </script>
</body>
</html>
