<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Products extends CI_Controller
{
	function  __construct() {
		parent::__construct();
		$this->load->library('paypal_lib');
		$this->load->model('product');
		$this->load->library('session');		
		if($this->session->userdata('email')=='')
		{
			redirect('user1');
		}	
	}
	
	function index(){
		$data = array();
		$id=$_GET['id'];
		//get products data from database
        $data['products'] = $this->product->getRows($id);
		//pass the products data to view
		$this->load->view('products/index', $data);
	}
	
	function buy(){
		$data = array();
		$id=$_GET['id'];
		//Set variables for paypal form
		$data = $this->product->get_data($id);
		$returnURL = site_url().'/paypal/success'; //payment success url
		$cancelURL = site_url().'/paypal/cancel?order_id='.$data->order_id; //payment cancel url
		$notifyURL = site_url().'/paypal/ipn'; //ipn url
		//get particular product data
		 //current user id
		$logo = base_url().'assets/images/codexworld-logo.png';
		//print_r($notifyURL); die;
		$delivery_cost=round($data->delivery_cost);
		$this->paypal_lib->add_field('return', $returnURL);
		$this->paypal_lib->add_field('cancel_return', $cancelURL);
		$this->paypal_lib->add_field('notify_url', $notifyURL);
		$this->paypal_lib->add_field('item_name', $data->pickup_first_name);
		$this->paypal_lib->add_field('custom',$data->user_id);
		$this->paypal_lib->add_field('item_number',$data->order_id);
		$this->paypal_lib->add_field('amount',$delivery_cost);		
		$this->paypal_lib->image($logo);
		$this->paypal_lib->paypal_auto_form();
		
	}
}